define([
    'underscore',
    'modules/page/popup/popup-view',
    'modules/notifications/notification-cancellation-popup-view',
],
function(_, PopupView, NotificationCancellationPopupView) {
    'use strict';

    describe('Notification Cancellation Popup View', function() {
        var view;
        var $view;

        beforeEach(function() {
            spyOn(NotificationCancellationPopupView.prototype, 'closePopup').and.callThrough();

            view = new NotificationCancellationPopupView({
                // remove transition animation
                attributes: _.extend({'data-transition': 'none'}, PopupView.prototype.attributes),
                elAfterClose: '.element-for-focus',
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;

            spyOn($('.element-for-focus')[0], 'focus').and.callThrough();
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('.ui-title').text()).toEqual('Confirmation');
        });

        it('presents the user with the expected prompt', function() {
            expect($view.find('.ui-content p').text()).toEqual('You are deleting this notification from your list. Do you want to continue?');
        });

        it("closes the confirmation popup when the 'no' button is clicked", function() {
            view.openPopup();
            $view.find('#notification-cancellation-return-btn').click();
            expect(view.closePopup).toHaveBeenCalled();
        });

        it("focuses back on the delete button after the 'no' button is clicked", function() {
            view.openPopup();
            $view.find('#notification-cancellation-return-btn').click();
            expect(view.closePopup).toHaveBeenCalled();
            expect($('.element-for-focus')[0].focus).toHaveBeenCalled();
        });

    });
}
);
